"""
Name: func.py
Author: Yuxiang LI (li.yuxiang.nj@gmail.com)
Data: 25/03/2016

Description: Load the mat file provided by Burger and transform it so Keras can use easily
"""

import scipy.io as sio

weight_file = 'weights_cvpr.mat'

w = sio.loadmat(weight_file)

w_1 = w['w'][0][0]
w_2 = w['w'][0][1]
w_3 = w['w'][0][2]
w_4 = w['w'][0][3]
w_5 = w['w'][0][4]

w_1 = [w_1[0:2047,0:289].transpose(), w_1[0:2047,289:290].reshape(2047,)]
w_2 = [w_2[0:2047,0:2047].transpose(), w_2[0:2047,2047:2048].reshape(2047,)]
w_3 = [w_3[0:2047,0:2047].transpose(), w_3[0:2047,2047:2048].reshape(2047,)]
w_4 = [w_4[0:2047,0:2047].transpose(), w_4[0:2047,2047:2048].reshape(2047,)]
w_5 = [w_5[0:289,0:2047].transpose(), w_5[0:289,2047:2048].reshape(289,)]

from keras.models import Sequential
from keras.layers import Dense, Activation
from keras.optimizers import SGD

patch = 17

model = Sequential()
model.add(Dense(2047, input_dim=patch * patch, init='he_normal', weights = w_1))
model.add(Activation('tanh'))
model.add(Dense(2047, init='he_normal', weights = w_2))
model.add(Activation('tanh'))
model.add(Dense(2047, init='he_normal', weights = w_3))
model.add(Activation('tanh'))
model.add(Dense(2047, init='he_normal', weights = w_4))
model.add(Activation('tanh'))
model.add(Dense(patch * patch, init='he_normal', weights = w_5))

sgd = SGD(lr=0.1, decay=0, momentum=0)  # not important for testing
model.compile(loss='mean_squared_error', optimizer=sgd)

json_string = model.to_json()
open('model.json', 'w').write(json_string)

model.save_weights('weights.h5')
